using System.DirectoryServices.ActiveDirectory;

namespace AP8_Lilian_Coutant
{
    public partial class Menu : Form
    {
        bool Ip_valid = false, CIDR_valid = false;

        public Menu()
        {
            InitializeComponent();

        }

        private void calc_ip_Click(object sender, EventArgs e)//Quand on clic sur le bouton calculer qui calcul l'adresse rseau
        {

            Global.adresse_rseau = "";
            Global.masque_sous_rseau = Global.masque_sous_rseau_bin;
            string[] octet = Global.masque_sous_rseau.Split(' ');//Permet de sparer avec un caractre des lements dans une liste  
            for (int i = 0; i <= 8; i++)
            {
                //On converti tout les octet du masque en Byte
                Global.mask1 = Convert.ToByte(octet[0], 2);
                Global.mask2 = Convert.ToByte(octet[1], 2);
                Global.mask3 = Convert.ToByte(octet[2], 2);
                Global.mask4 = Convert.ToByte(octet[3], 2);
                //On rcupre tout les octet en binaire 
                Global.mask1_bin = octet[0];
                Global.mask2_bin = octet[1];
                Global.mask3_bin = octet[2];
                Global.mask4_bin = octet[3];

            }
            Global.masque_sous_rseau = Global.mask1 + "." + Global.mask2 + "." + Global.mask3 + "." + Global.mask4;//Format utiliser pour le masque sous la forme dcimal
            Int16[] puissance_2 = new Int16[] { 128, 64, 32, 16, 8, 4, 2, 1 };//On initialise un tableau comportant toutes les puissances de 2 pour faire un ET logique par la suite
            for (int i = 0; i < 8; i++)
            {
                if (Global.octet1_bin[i] == '1' & Global.mask1_bin[i] == '1')//Opration ET logique permettant que si le bit des deux octets est 1 
                {
                    Global.rseau1 += Convert.ToByte(puissance_2[i]);
                }

                if (Global.octet2_bin[i] == '1' & Global.mask2_bin[i] == '1')
                {
                    Global.rseau2 += Convert.ToByte(puissance_2[i]);
                }

                if (Global.octet3_bin[i] == '1' & Global.mask3_bin[i] == '1')
                {
                    Global.rseau3 += Convert.ToByte(puissance_2[i]);
                }
                if (Global.octet4_bin[i] == '1' & Global.mask4_bin[i] == '1')
                {
                    Global.rseau4 += Convert.ToByte(puissance_2[i]);
                }

            }
            Global.adresse_rseau = Global.rseau1 + "." + Global.rseau2 + "." + Global.rseau3 + "." + Global.rseau4 + "/" + Global.CIDR;
            
            Rseau ouvre = new Rseau();
            this.Hide();
            ouvre.Show();


        }

        private void verif_ip_Click(object sender, EventArgs e)//Quand on clic sur le bouton verif, cela vrifie si l'ip est valide
        {
            CIDR_VERIF.Enabled = false;
            calc_ip.Visible = false;

            tb_resultat.Text = "";
            bool erreur = false;//initialise une erreur s'il y en a elle passe en true


            Global.addresse_Ip = tb_ip.Text;
            string[] octet = Global.addresse_Ip.Split('.');//methode Split permettant de diviser une chaine

            if (octet.Length != 4)//si le format de l'adresse n'est pas conforme on a un message d'erreur
            {
                Ip_valid = false;
                erreur = true;
            }
            for (int i = 0; i < Global.addresse_Ip.Length; i++)
            {
                //Si le caractre n'est pas un . et ne se trouve pas entre 0 et 9, on a une erreur
                if (Global.addresse_Ip[i] != '.' && Global.addresse_Ip[i] < '0' || Global.addresse_Ip[i] > '9')
                {
                    Ip_valid = false;
                    erreur = true;
                }
            }
            if (erreur)//Si il y a une erreur
            {
                MessageBox.Show("Ip non conforme");//Affiche un message d'erreur
            }
            else
            {
                for (int i = 0; i < octet.Length; i++)
                {
                    //Si l'octet est vide, on a une erreur
                    if (octet[i] == "")
                    {
                        Ip_valid = false;
                        erreur = true;
                    }
                    //Si la longueur de la chaine est superieur  3, on a une erreur
                    else if (octet[i].Length > 3)
                    {
                        Ip_valid = false;
                        erreur = true;
                    }
                    else if (int.Parse(octet[i]) < 0 | int.Parse(octet[i]) > 255)//si l'octet n'est pas entre 0 et 255 on a une erreur
                    {
                        Ip_valid = false;
                        erreur = true;
                    }
                }
                if (erreur)
                {
                    MessageBox.Show("Ip non conforme");
                }
            }

            if (erreur == false)//s'il n'y a pas d'erreur on lance
            {
                Global.octet1 = Convert.ToByte(octet[0]);
                Global.octet2 = Convert.ToByte(octet[1]);
                Global.octet3 = Convert.ToByte(octet[2]);
                Global.octet4 = Convert.ToByte(octet[3]);

                for (int i = 0; i < octet.Length; i++)
                {
                    Global.octet1_bin = Convert.ToString(Int16.Parse(octet[0]), 2);
                    Global.octet2_bin = Convert.ToString(Int16.Parse(octet[1]), 2);
                    Global.octet3_bin = Convert.ToString(Int16.Parse(octet[2]), 2);
                    Global.octet4_bin = Convert.ToString(Int16.Parse(octet[3]), 2);



                }
                for (int i = 0; i < 8; i++)//Rempli par des 0 pour remplir les octets o les bits sont vides
                {
                    if (Global.octet1_bin.Length != 8)
                    {
                        Global.octet1_bin = "0" + Global.octet1_bin;
                    }
                    if (Global.octet2_bin.Length != 8)
                    {
                        Global.octet2_bin = "0" + Global.octet2_bin;
                    }
                    if (Global.octet3_bin.Length != 8)
                    {
                        Global.octet3_bin = "0" + Global.octet3_bin;
                    }
                    if (Global.octet4_bin.Length != 8)
                    {
                        Global.octet4_bin = "0" + Global.octet4_bin;
                    }

                }
                if (Global.octet1 < 128)
                {
                    Global.classe = "A";
                    Global.masque_classe = 8;
                }
                else if (Global.octet1 < 192)
                {
                    Global.classe = "B";
                    Global.masque_classe = 16;
                }
                else if (Global.octet1 < 224)
                {
                    Global.classe = "C";
                    Global.masque_classe = 24;
                }
                else if (Global.octet1 < 240)
                {
                    Global.classe = "D";
                    Global.masque_classe = 0;
                }
                else
                {
                    Global.classe = "E";
                    Global.masque_classe = 0;
                }
                tb_resultat.Text = Global.octet1_bin + " " + Global.octet2_bin + " " + Global.octet3_bin + " " + Global.octet4_bin;
                Ip_valid = true;
                CIDR_VERIF.Enabled = true;
            }

            if (CIDR_valid == true && Ip_valid == true) //Permet d'afficher le bouton permettant de Calculer l'adresse rseau
            {
                calc_ip.Visible = true;
            }

        }

        private void CIDR_VERIF_Click(object sender, EventArgs e)//Vrifie le CIDR 
        {
            Global.masque_sous_rseau_bin = "";
            Global.CIDR = (byte)CIDR1.Value;
            for (int i = 1; i <= Global.CIDR; i++)//Boucle qui permet d'avoir le masque en binaire
            {
                Global.masque_sous_rseau_bin += "1";
                if (i % 8 == 0)
                {
                    Global.masque_sous_rseau_bin += " ";
                }
            }
            for (int i = Global.CIDR; i < 32; i++)//Rempli le reste du masque en binaire avec des 0
            {
                Global.masque_sous_rseau_bin += "0";
                //Comme on ajoute un caractre juste avant il y a un dcalage dans la chaine
                //donc on fait modulo 8%==7 au lieu de %0 et si n'est pas au dernier caractre
                if (i % 8 == 7 && i != 31)
                {
                    Global.masque_sous_rseau_bin += " ";
                }
            }
            if (Global.CIDR < Global.masque_classe)//Si le masque est inferieur  celui de sa classe cela renvoie une erreur
            {
                MessageBox.Show("Masque pas assez lev");
            }
            else
            {
                CIDR_valid = true;
                if (CIDR_valid == true && Ip_valid == true)//Permet d'afficher le bouton permettant de Calculer l'adresse rseau
                {
                    calc_ip.Visible = true;
                }
            }
                


        }

        private void leave_Click(object sender, EventArgs e)//Fonction qui Quand on clic sur le bouton Quitter cela ferme notre application
        {
            Application.Exit();
        }
        private void new_commande_Click(object sender, EventArgs e)//Permet de faire une nouvelle commande donc rinitialise les donnes
        {
            CIDR1.Value = 0;
            tb_ip.Clear();
            tb_resultat.Clear();
            Global.masque_sous_rseau_bin = "";
            Global.rseau1 = 0;
            Global.rseau2 = 0;
            Global.rseau3 = 0;
            Global.rseau4 = 0;
            Global.mask1 = 0;
            Global.mask2 = 0;
            Global.mask3 = 0;
            Global.mask4 = 0;
            Ip_valid = false;
            CIDR_valid = false;
            calc_ip.Visible = false;
            CIDR_VERIF.Enabled = false;

        }
    }
}
